<%@ LANGUAGE="VBScript" %>

<% '***************************************************************************
   '* ASP Football Pool                                                       *
   '*                                                                         *
   '* Copyright 2000 by Mike Hall                                             *
   '* Please see http://www.brainjar.com for documentation and terms of use.  *
   '***************************************************************************
%>

<!-- #include file="protect.inc" -->
<!-- #include file="common.inc" -->
<!-- #include file="header.inc" -->

<% 'Open the database.

   call OpenDB()

  'Get the current week number.

   week = CurrentWeek %>
<p><table class="formatted" cellpadding=0 cellspacing=0 width=540>
<tr><th>Are you ready for some football?</th></tr>
<tr><td>
<h4>This is Week <% = week %></h4>

<p>Welcome to the Football Pool. As the administrator you'll want to update
this page with your own message.</p>
<% 'List any early games left in the schedule.

   found = false
   first = true
   dateNow = CurrentDateTime()
  sql = "select * from Schedule" _
     & " where Date + Time > #" & DateValue(dateNow) & " " & TimeValue(dateNow) & "#" _
     & " order by Date, Time"
   set rs = DbConn.Execute(sql)
   if not (rs.BOF and rs.EOF) then
     week = 0
     do while not rs.EOF
       dayName = Weekday(rs.Fields("Date").Value)
       if week <> rs.Fields("Week").Value and _
          dayName <> vbSunday and _
          dayName <> vbMonday then
           week = rs.Fields("Week").Value
           if first then
             first = false
             found = true %>
<h4>Early Games this Season</h4>

<p>There are early games on the following dates, be sure to make your picks for
these games on time:</p>

<ul>
<%         end if %>
  <li><a href="entry.asp?week=<% = rs.Fields("Week").Value %>">Week <% = rs.Fields("Week").Value %></a> -
      <% = FormatDatetime(rs.Fields("Date").Value & " " & rs.Fields("Time").Value, vbLongDate) %></li>
<%     end if
       rs.MoveNext
     loop
     if found then %>
</ul>
<p>
<%   end if
   end if %>

<p>See the <a href="help.asp">Help</a> section for rules and instructions.</p>

</td></tr>
</table></p>

<!-- #include file="footer.inc" -->
